import matplotlib.pyplot as plt


R_values = [1, 3, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60]

# OUR method(Adaptive μ) 
adaptive_mu_case1_loss = [0.3254, 0.2487, 0.2358, 0.2270, 0.2245, 0.2234, 0.2228, 0.2225, 0.2226, 0.2222, 0.2223, 0.2222, 0.2225, 0.2222]
adaptive_mu_case1_acc = [0.8257, 0.8444, 0.8538, 0.8658, 0.8695, 0.8724, 0.8729, 0.8747, 0.8739, 0.8754, 0.8744, 0.8757, 0.8748, 0.8757]

adaptive_mu_case2_loss = [0.3783, 0.2729, 0.2524, 0.2364, 0.2307, 0.2279, 0.2264, 0.2256, 0.2247, 0.2240, 0.2236, 0.2235, 0.2233, 0.2235]
adaptive_mu_case2_acc = [0.8128, 0.8273, 0.84, 0.8526, 0.86, 0.8639, 0.8659, 0.8675, 0.8689, 0.8696, 0.8708, 0.8723, 0.8712, 0.8719]

# Fixed μ (baseline/FedProx)
fixed_mu_case1_loss = [0.3998, 0.3188, 0.2778, 0.2482, 0.2386, 0.2341, 0.2307, 0.2288, 0.2274, 0.2267, 0.2259, 0.2253, 0.2246, 0.2245]
fixed_mu_case1_acc = [0.8069, 0.8268, 0.835, 0.8428, 0.852, 0.8567, 0.8595, 0.8636, 0.8665, 0.868, 0.8669, 0.8697, 0.8704, 0.8694]

fixed_mu_case2_loss = [0.4158, 0.3343, 0.2955, 0.2581, 0.2455, 0.2386, 0.2344, 0.2315, 0.2298, 0.2287, 0.2279, 0.2270, 0.2260, 0.2281]
fixed_mu_case2_acc = [0.7924, 0.8183, 0.8279, 0.839, 0.8432, 0.8528, 0.8564, 0.8593, 0.8608, 0.8642, 0.8663, 0.8682, 0.8694, 0.8637]

label_fontsize = 30
tick_fontsize = 25
legend_fontsize = 25


plt.rcParams['font.family'] = 'Times New Roman'  


plt.figure(figsize=(8, 6))
plt.plot(R_values, adaptive_mu_case1_loss, label='Adaptive μ - Case 1', marker='o', color='blue')
plt.plot(R_values, adaptive_mu_case2_loss, label='Adaptive μ - Case 2', marker='o', color='blue', linestyle='dashed')
plt.plot(R_values, fixed_mu_case1_loss, label='Fixed μ - Case 1', marker='s', color='green')
plt.plot(R_values, fixed_mu_case2_loss, label='Fixed μ - Case 2', marker='s', color='green', linestyle='dashed')

plt.xlabel('Total Resource R (Seconds)', fontsize=label_fontsize)
plt.ylabel('Loss Value', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)
plt.tight_layout()


plt.savefig('loss_plot_resource.png', dpi=300, bbox_inches='tight')
plt.savefig('loss_plot_resource.svg', format='svg', bbox_inches='tight')
plt.savefig('loss_plot_resource.pdf', format='pdf', bbox_inches='tight')
plt.show()


plt.figure(figsize=(8, 6))
plt.plot(R_values, adaptive_mu_case1_acc, label='Adaptive μ - Case 1', marker='o', color='blue')
plt.plot(R_values, adaptive_mu_case2_acc, label='Adaptive μ - Case 2', marker='o', color='blue', linestyle='dashed')
plt.plot(R_values, fixed_mu_case1_acc, label='Fixed μ - Case 1', marker='s', color='green')
plt.plot(R_values, fixed_mu_case2_acc, label='Fixed μ - Case 2', marker='s', color='green', linestyle='dashed')

plt.xlabel('Total Resource R (Seconds)', fontsize=label_fontsize)
plt.ylabel('Accuracy', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)
plt.tight_layout()

plt.savefig('accuracy_plot_resource.png', dpi=300, bbox_inches='tight')
plt.savefig('accuracy_plot_resource.svg', format='svg', bbox_inches='tight')
plt.savefig('accuracy_plot_resource.pdf', format='pdf', bbox_inches='tight')
plt.show()
